<?php if( have_rows('content_block') ): ?>
  <?php while( have_rows('content_block') ): ?> <?php  the_row()  ?>

  <?php 
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'content_block' . '-' ),
      'title' => get_sub_field( 'title' ),
      'sub_title' => get_sub_field( 'sub_title' ),
      'text' => get_sub_field( 'text' ),
      'buttons' => get_sub_field( 'buttons' ),
      'background' => get_sub_field( 'background' ),
      'icon' => get_sub_field( 'icon' ),
      'padding' => get_sub_field( 'content_block_padding' ),
    ];

    $classes = [
      'layout-item',
      'content_block',
      $fields['background'],
      'pt-' . $fields['padding']['top'],
      'pb-' . $fields['padding']['bottom']
    ];

    if( \App\layout_has_bg( $fields['background'] ) ) {
      $classes[] = 'has-bg';
    }
   ?>

  <?php if( ! empty( $fields['title'] ) || ! empty( $fields['sub_title'] ) || ! empty( $fields['text'] ) || ! empty( $fields['buttons'] || ! empty( $fields['icon'] ) ) ): ?>
    <section id="<?php echo e($fields['layout_id']); ?>" class="<?php echo e(implode( ' ', $classes )); ?>">
      <div class="container">
        <div class="cb-content">
          <?php if( ! empty( $fields['icon'] ) ): ?>
            <i class="cb-icon <?php echo e($fields['icon']); ?>"></i>
          <?php endif; ?>

          <?php if( ! empty( $fields['sub_title'] ) ): ?>
            <h4 class="cb-sub-title"><?php echo e($fields['sub_title']); ?></h4>
          <?php endif; ?>

          <?php if( ! empty( $fields['title'] ) ): ?>
            <h3 class="cb-title"><?php echo e($fields['title']); ?></h3>
          <?php endif; ?>

          <?php if( ! empty( $fields['text'] ) ): ?>
            <div class="cb-text rlpm">
              <?php echo $fields['text']; ?>

            </div>
          <?php endif; ?>

          <?php if( ! empty( $fields['buttons'] ) ): ?>
            <div class="cb-buttons btn-troop">
              <?php $__currentLoopData = $fields['buttons']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo \App\the_wpc_button([
                  'data' => $button['button']
                ]); ?>

              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </section>
  <?php endif; ?>

  <?php endwhile; ?>
<?php endif; ?>
