<?php 
  global $post, $wp_query, $post;
  $post_id = wpc_get_the_id();

  $post = get_post($post_id);

  if( empty( $post->post_parent ) ) {
    return;
  }

  setup_postdata($post);

  $parent_id    = $post->post_parent;
  $uniqid       = uniqid( 'sub-nav-' );

  $wp_query = null;
  $args     = array(
    'post_type'      => array( 'page' ),
    'orderby'        => 'menu_order',
    'order'          => 'ASC',
    'posts_per_page' => - 1,
    'post_parent'    => $parent_id
  );
  $wp_query = new WP_Query();
  $wp_query->query( $args );
 ?>

<?php if( $wp_query->have_posts() ): ?>
  <div class="subnav bg-secondary">
    <div class="container">
      <div class="card bg-secondary card-responsive">
        <h4 class="card-header" role="tab">
          <a class="collapsed" href="#<?php echo e($uniqid); ?>" data-toggle="collapse" role="button" aria-expanded="true"
             aria-controls="<?php echo e($uniqid); ?>">
            <?php echo e(get_the_title( $post_id )); ?>


            <button type="button" class="btn-link card-toggle">
              <span class="sr-only"><?php echo e(__( 'Open Sub Navigation', 'hux' )); ?></span>
              <i></i>
            </button>
          </a>
        </h4>
        <div id="<?php echo e($uniqid); ?>" class="dropdown-content card-collapse collapse">
          <div class="card-block">
            <div class="sub-nav-inner">
              <ul class="nav">
                <?php while( $wp_query->have_posts() ): ?>  <?php ( $wp_query->the_post() ); ?>
                <li class="nav-item <?php echo e($post_id === get_the_ID() ? 'active' : ''); ?>">
                  <a class="nav-link" href="<?php echo e(get_the_permalink()); ?>" title="<?php echo e(get_the_title()); ?>">
                    <span><?php echo e(get_the_title()); ?></span>
                  </a>
                </li>
                <?php endwhile; ?>
              </ul>
            </div>
          </div>
        </div>
      </div>
      <?php ( wp_reset_query() ); ?>
    </div>
  </div>
<?php endif; ?>
<?php ( wp_reset_postdata() ); ?>
