<?php if( have_rows('quotes') ): ?>
  <?php while( have_rows('quotes') ): ?> <?php  the_row()  ?>

  <?php 
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'quotes' . '-' ),
      'title' => get_sub_field( 'title' ),
      'quotes_to_show' => get_sub_field( 'quotes_to_show' ),
      'orderby' => get_sub_field( 'orderby' ),
      'order' => get_sub_field( 'order' ),
      'image' => get_sub_field( 'image' ),
      'background' => get_sub_field( 'background' ),
      'slider_settings' => get_sub_field( 'quotes_slider_settings' ),
    ];

    $classes = [
      'layout-item',
      'quotes',
      $fields['background'],
    ];

    $fields['quotes'] = get_posts([
      'post_type' => 'hux_quote',
      'post_status' => 'publish',
      'orderby' => $fields['orderby'],
      'order' => $fields['order'],
      'posts_per_page' => absint( $fields['quotes_to_show'] )
    ]);

    if( \App\layout_has_bg( $fields['background'] ) ) {
      $classes[] = 'has-bg';
    }
   ?>

  <?php if( ! empty( $fields['quotes'] ) ): ?>
    <section id="<?php echo e($fields['layout_id']); ?>" class="<?php echo e(implode( ' ', $classes )); ?>">
      <div class="row flex-md-row-reverse ml-0 mr-0">
        <div class="col-md-6 pl-0 pr-0">
          <?php if( ! empty( $fields['image'] ) ): ?>
            <figure class="quotes-thumbnail img-cover mb-0">
              <?php echo \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail' ); ?>

            </figure>
          <?php endif; ?>
        </div>

        <div class="col-md-6 pl-0 pr-0 justify-content-centeralign-items-center">
          <div class="quotes-carousel-wrap <?php echo e($fields['slider_settings']['dots'] === 'enabled' ? 'has-dots' : ''); ?> <?php echo e($fields['slider_settings']['arrows'] === 'enabled' ? 'has-arrows' : ''); ?>">
            <?php if( ! empty( $fields['title'] ) ): ?>
              <h3 class="quotes-title"><?php echo e($fields['title']); ?></h3>
            <?php endif; ?>

            <div class="quotes-carousel"
                 data-arrows="<?php echo e($fields['slider_settings']['arrows']); ?>"
                 data-dots="<?php echo e($fields['slider_settings']['dots']); ?>"
                 data-autoplay="<?php echo e($fields['slider_settings']['autoplay']); ?>"
                 data-interval="<?php echo e($fields['slider_settings']['interval'] * 1000); ?>">

              <?php $__currentLoopData = $fields['quotes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if( ! empty( $quote = get_field( 'quote', $quote->ID ) ) ): ?>
                  <div class="quotes-slide">
                    <div class="quotes-slide-inner">
                      <i class="quote-icon hux-icon-quotes-left"></i>
                      <q class="quote-text rlpm">
                        <?php echo $quote; ?>

                      </q>
                    </div>
                  </div>
                <?php endif; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="quotes-arrows"></div>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>

  <?php endwhile; ?>
<?php endif; ?>
