<?php 
  $fields = [
    'title' => get_field( 'title', get_the_ID() ),
    'image' => get_field( 'thumbnail', get_the_ID() ),
    'region' => wp_get_post_terms( get_the_ID(), 'region', array('fields' => 'names') ),
  ];

$thumbnailAnim = array(
  'animation' => 'fade',
  'delay'     => 0.1,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);

$contentAnim = array(
  'animation' => 'fade-up',
  'delay'     => 0,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);
 ?>


<article <?php (post_class()); ?> <?= \App\get_the_aos($contentAnim); ?>>
  <?php if( ! empty( $thumbnail = get_field( 'thumbnail', get_the_ID() ) ) ): ?>

    <div class="row align-items-md-center">
      <div class="col-md-8">
        <?php if( ! empty( $fields['image'] ) ): ?>
          <?php if(get_field('is_video', get_the_ID())): ?>
            <a href="<?php echo e(get_field('video_url', get_the_ID())); ?>" class="video-link link">
              <i class="hux-icon-play" aria-hidden="true"></i>
          <?php endif; ?>
              <figure class="post-thumbnail img-cover mb-0" <?= \App\get_the_aos($thumbnailAnim); ?>>
                <?php echo \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail-md' ); ?>

              </figure>
          <?php if(get_field('is_video', get_the_ID())): ?>
            </a>
          <?php endif; ?>
        <?php endif; ?>
      </div>

      <div class="col-md-4">
        <div class="post-content">
          <h4 class="post-title">
            <?php echo e(get_the_title()); ?>


            <?php if( ! empty( $fields['region'] ) ): ?>
              <span><?php echo e($fields['region'][0]); ?></span>
            <?php endif; ?>
          </h4>

          <?php if(! empty($excerpt = get_field('excerpt', get_the_ID())) ): ?>
            <div class="post-text">
              <?php echo $excerpt; ?>

            </div>
          <?php endif; ?>


          <div class="post-buttons">
            <?php if(get_field('is_video', get_the_ID())): ?>
              <a href="<?php echo e(get_field('video_url', get_the_ID())); ?>"
                 class="btn btn-primary video-link"><?php echo e(__('Watch video', 'hux')); ?></a>
            <?php else: ?>
              <a href="<?php echo e(get_permalink()); ?>" class="btn btn-primary"><?php echo e(__('Read more', 'hux')); ?></a>
            <?php endif; ?>
          </div>

        </div>
      </div>
    </div>
  <?php endif; ?>
</article>
