<?php 
  $fields = [
    'title' => get_field( 'title', get_the_ID() ),
    'image' => get_field( 'thumbnail', get_the_ID() ),
    'region' => wp_get_post_terms( get_the_ID(), 'region', array('fields' => 'names') ),
  ];

$thumbnailAnim = array(
  'animation' => 'fade',
  'delay'     => 0.1,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);

$contentAnim = array(
  'animation' => 'fade-up',
  'delay'     => 0.1,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);
 ?>


<article <?php (post_class()); ?> <?= \App\get_the_aos($contentAnim); ?>>
  <?php if( ! empty( $thumbnail = get_field( 'thumbnail', get_the_ID() ) ) ): ?>

    <div class="row align-items-md-center">
      <div class="col-md-8">
        <?php if( ! empty( $fields['image'] ) ): ?>
          <a href="<?php echo e(get_permalink()); ?>" class="property-link" title="<?php echo e(get_the_title()); ?>">
            <figure class="property-thumbnail img-cover mb-0" <?= \App\get_the_aos($thumbnailAnim); ?>>
              <?php echo \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail-md' ); ?>

            </figure>
          </a>
        <?php endif; ?>
      </div>

      <div class="col-md-4">
        <div class="property-content">
          <h4 class="property-title">
            <?php if( ! empty( $fields['region'] ) ): ?>
              <span><?php echo e($fields['region'][0]); ?></span>
            <?php endif; ?>
            <?php echo e(get_the_title()); ?>

          </h4>
          <?php if( get_field ('single_price',  get_the_ID() )  && ! empty( $price = get_field( 'property_price', get_the_ID() ) )): ?>
            <span class="property-price single"><?php echo \App\generate_price($price, 'none', 'code'); ?></span>
          <?php endif; ?>

          <?php if( ! get_field ('single_price',  get_the_ID() ) && ! empty( $priceFrom = get_field( 'property_price_from', get_the_ID() ) )
           && ! empty( $priceTo = get_field( 'property_price_to', get_the_ID() ) )): ?>
            <div class="property-price multiple"><?php echo \App\generate_price($priceFrom, 'none', 'none'); ?>

              - <?php echo \App\generate_price($priceTo, 'none', 'code'); ?></div>
          <?php endif; ?>

          <?php if(! empty($excerpt = get_field('excerpt', get_the_ID())) ): ?>
            <div class="property-text">
              <?php echo $excerpt; ?>

            </div>
          <?php endif; ?>


          <div class="property-buttons">
            <a href="<?php echo e(get_permalink()); ?>" class="btn btn-primary"><?php echo e(__('View Property', 'hux')); ?></a>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
</article>
