<?php 
  $fields = [
    'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( get_row_layout() . '-' ),
    'form_title' =>  get_sub_field('form_title'),
    'form' =>  get_sub_field('form'),
    'offices' =>  get_sub_field('offices'),
  ];
 ?>

<section id="<?php echo e($fields['layout_id']); ?>" class="layout-item <?php echo e(get_row_layout()); ?>">
  <div class="container">
    <div class="row">
      <div class="col-md-4 office-column">
        <?php $__currentLoopData = $fields['offices']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $office): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="office-item">
            <?php if( ! empty( $title = $office['name'] ) ): ?>
              <h5 class="office-title"><?php echo e($title); ?></h5>
            <?php endif; ?>

            <?php if( ! empty( $phone = $office['phone'] ) ): ?>
              <a href="tel: <?php echo e($phone); ?>" rel="nofollow" title="<?php echo e(__('Call Us', 'hux')); ?>"
                 class="phone"><?php echo e($phone); ?></a>
            <?php endif; ?>

            <?php if( ! empty( $email = $office['email'] ) ): ?>
              <a href="mail: <?php echo e($email); ?>" rel="nofollow" title="<?php echo e(__('Email Us', 'hux')); ?>"
                 class="email"><?php echo e($email); ?></a>
            <?php endif; ?>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
      <div class="col-md-8">
        <div class="form-column">
          <?php if( ! empty( $form_title = $fields['form_title'] ) ): ?>
            <h3 class="form-title"><?php echo e($form_title); ?></h3>
          <?php endif; ?>
          <?php if( ! empty( $fields['form'] ) ): ?>
            <?php ( gravity_form( $fields['form']['id'], false, false, false, '', true, 1 ) ); ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</section>
