<?php if( have_rows('background_image_content') ): ?>
  <?php while( have_rows('background_image_content') ): ?> <?php  the_row()  ?>

  <?php 
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'background-image-conten' . '-' ),
      'title' => get_sub_field( 'title' ),
      'image' => get_sub_field( 'image' ),
      'content' => get_sub_field( 'content' ),
      'background_image' => get_sub_field( 'background_image' ),
      'buttons' => get_sub_field( 'buttons' ),
    ];

    $classes = [
      'layout-item',
      'background_image_content'
    ];
   ?>

  <section id="<?php echo e($fields['layout_id']); ?>" class="<?php echo e(implode( ' ', $classes )); ?>">
    <?php if( ! empty( $fields['background_image'] ) ): ?>
      <figure class="bg-thumbnail img-cover mb-0">
        <?php echo \App\get_responsive_attachment( $fields['background_image'], 'hux-thumbnail-lg' ); ?>

      </figure>
    <?php endif; ?>

    <div class="content-wrap">
      <div class="container">
        <div class="content-inner row">
          <div class="content">
            <?php if( ! empty( $fields['title'] ) ): ?>
              <h4 class="content-title"><?php echo $fields['title']; ?></h4>
            <?php endif; ?>

            <?php if( ! empty( $fields['content'] ) ): ?>
              <p class="content-text"><?php echo $fields['content']; ?></p>

              <?php if( ! empty( $fields['image'] ) ): ?>
                <figure class="content-image mb-0">
                  <?php echo \App\get_responsive_attachment( $fields['image'], 'hux-thumbnail-xs' ); ?>

                </figure>
              <?php endif; ?>
            <?php endif; ?>

              <?php if( ! empty( $fields['buttons'] ) ): ?>
                <div class="cb-buttons btn-troop mt-4">
                  <?php $__currentLoopData = $fields['buttons']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo \App\the_wpc_button([
                      'data' => $button['button']
                    ]); ?>

                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </section>

  <?php endwhile; ?>
<?php endif; ?>

