<?php 
  if ( empty( $url ) ) {$url = get_the_permalink();}

  $settings = \Roots\ShareButtons\Admin\get_settings();
  $thumb_id = get_post_thumbnail_id( get_the_ID() );

  if ( empty( $title ) ) {$title = get_the_title();}
 ?>

<?php if( ! empty( $settings['button_order'] ) ): ?>
  <div class="entry-share">
    <ul class="entry-share-btns text-center">
      <li class="list-inline-item muted">
        <?php echo e(__('Share', 'hux')); ?>

      </li>
      <?php foreach( $settings['button_order'] as $setting ) : ?>
      <?php if( 'twitter' === $setting && in_array( 'twitter', $settings['buttons'] ) ): ?>
        <li class="entry-share-btn entry-share-btn-twitter">
          <a
            href="https://twitter.com/intent/tweet?text=<?php echo e(urlencode( html_entity_decode( $title, ENT_COMPAT, 'UTF-8' ) )); ?>&amp;url=<?php echo e(urlencode( $url )); ?>"
            title="<?php echo e(__( 'Share on Twitter', 'hux' )); ?>">
            <i class="hux-icon-twitter"></i>
          </a>
        </li>
      <?php endif; ?>

      <?php if( 'facebook' === $setting && in_array( 'facebook', $settings['buttons'] ) ): ?>
        <li class="entry-share-btn entry-share-btn-facebook">
          <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode( $url )); ?>"
             title="<?php echo e(__( 'Share on Facebook', 'hux' )); ?>">
            <i class="hux-icon-facebook"></i>
          </a>
        </li>
      <?php endif; ?>

      <?php if( 'google_plus' === $setting && in_array( 'google_plus', $settings['buttons'] ) ): ?>
        <li class="entry-share-btn entry-share-btn-google-plus">
          <a href="https://plus.google.com/share?url=<?php echo e(urlencode( $url )); ?>"
             title="<?php echo e(__( 'Share on Google+', 'hux' )); ?>">
            <i class="hux-icon-google"></i>
          </a>
        </li>
      <?php endif; ?>

      <?php if( 'linkedin' === $setting && in_array( 'linkedin', $settings['buttons'] ) ): ?>
        <li class="entry-share-btn entry-share-btn-linkedin">
          <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(urlencode( $url )); ?>&amp;summary="
             title="<?php echo e(__( 'Share on LinkedIn', 'hux' )); ?>">
            <i class="hux-icon-linkedin"></i>
          </a>
        </li>
      <?php endif; ?>

      <?php if( 'pinterest' === $setting && in_array( 'pinterest', $settings['buttons'] ) && ( ! empty( $thumb_id ) || ! empty( get_field('thumbnail') ) ) ): ?>
        <?php 
          // Don't show 'Pin It' button if post doesn't have a thumbnail
          if ( empty( $thumb_id ) ) {$thumb_id = get_field( 'thumbnail' )['id'];}

          // Get thumbnail URL
          $thumb = wp_get_attachment_image_src( $thumb_id, 'thumbnail_size' );
          $thumb_src = ( isset( $thumb[0] ) ) ? $thumb[0] : null;
          $thumb_alt = get_post_meta( $thumb_id , '_wp_attachment_image_alt', true );

          // Make sure thumbnail URL isn't relative
          $thumb_src = phpUri::parse( network_site_url() )->join( $thumb_src );

          // Fallback to post title as a description if the post thumbnail doesn't have one
          $description = ( ! empty( $thumb_alt ) ) ? $thumb_alt : $title;
         ?>

        <li class="entry-share-btn entry-share-btn-pinterest">
          <a
            href="https://pinterest.com/pin/create/button/?url=<?php echo e(rawurlencode( $url )); ?>&amp;media=<?php echo e(urlencode( $thumb_src )); ?>&amp;description=<?php echo e(urlencode( $description )); ?>"
            title="<?php echo e(__( 'Share on Pinterest', 'hux' )); ?>">
            <i class="hux-icon-pinterest"></i>
          </a>
        </li>
      <?php endif; ?>
      <?php endforeach; ?>
    </ul>
  </div>
<?php endif; ?>
