<?php if( have_rows('cta_block') ): ?>
  <?php while( have_rows('cta_block') ): ?> <?php ( the_row() ); ?>

  <?php 
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'cta_block' . '-' ),
      'title' => get_sub_field( 'title' ),
      'sub_title' => get_sub_field( 'sub_title' ),
      'text' => get_sub_field( 'text' ),
      'buttons' => get_sub_field( 'buttons' ),
      'image' => get_sub_field( 'image' ),
      'direction' => get_sub_field( 'direction' ),
      'padding' => get_sub_field( 'cta_block_padding' ),
    ];

    $classes = [
      'layout-item',
      'cta_block',
      'direction-' . $fields['direction'],
      'pt-' . $fields['padding']['top'],
      'pb-' . $fields['padding']['bottom']
    ];

    $image_max_height = empty( $fields['image']['sizes']['hux-thumbnail-sm-height'] ) ? false : $fields['image']['sizes']['hux-thumbnail-sm-height'];
    $image_ratio = ( $fields['image']['height'] / $fields['image']['width'] ) * 100;

  $thumbnailAnim = array(
    'animation' => 'fade',
    'delay'     => 0.2,
    'duration'  => 1,
    'easing'    => '',
    'anchor'    => ''
  );

  $contentAnim = array(
    'animation' => 'fade-up',
    'delay'     => 0.2,
    'duration'  => 1,
    'easing'    => '',
    'anchor'    => ''
  );
   ?>

  <?php if( ! empty( $fields['title'] ) || ! empty( $fields['sub_title'] ) || ! empty( $fields['text'] ) || ! empty( $fields['buttons'] || ! empty( $fields['image'] ) ) ): ?>
    <section id="<?php echo e($fields['layout_id']); ?>" class="<?php echo e(implode( ' ', $classes )); ?>">
      <div class="container">
        <div class="row align-items-md-center <?php echo e(( $fields['direction'] === 'left' ) ? '' : 'flex-md-row-reverse'); ?>">
          <div class="col-md-8">
            <?php if( ! empty( $fields['image'] ) ): ?>
              <figure class="ctab-thumbnail img-cover mb-0" data-min="768" style="padding-top: <?php echo e(absint( $image_ratio )); ?>%; <?php echo e(empty( $image_max_height ) ? '' : 'min-height: ' . $image_max_height  . 'px'); ?>" <?= \App\get_the_aos($thumbnailAnim); ?>>
                <?php echo \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail-md' ); ?>

              </figure>
            <?php endif; ?>
          </div>

          <div class="col-md-4">
            <div class="ctab-content">
              <?php if( ! empty( $fields['sub_title'] ) ): ?>
                <h4 class="ctab-sub-title" <?= \App\get_the_aos($contentAnim); ?>>
                  <?php echo e($fields['sub_title']); ?>

                </h4>
              <?php endif; ?>

              <?php if( ! empty( $fields['title'] ) ): ?>
                <h3 class="ctab-title" <?= \App\get_the_aos($contentAnim); ?>>
                  <?php echo e($fields['title']); ?>

                </h3>
              <?php endif; ?>

              <?php if( ! empty( $fields['text'] ) ): ?>
                <div class="ctab-text rlpm" <?= \App\get_the_aos($contentAnim); ?>>
                  <?php echo $fields['text']; ?>

                </div>
              <?php endif; ?>

              <?php if( ! empty( $fields['buttons'] ) ): ?>
                <div class="ctab-buttons btn-troop" <?= \App\get_the_aos($contentAnim); ?>>
                  <?php $__currentLoopData = $fields['buttons']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo \App\the_wpc_button([
                      'data' => $button['button']
                    ]); ?>

                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>

  <?php endwhile; ?>
<?php endif; ?>
