@php
  $cr = get_field( 'cp', 'option' );
@endphp

@if( ! empty( $title = $cr['title'] ) )
  <h3 class="title text-center">{{ $title }}</h3>
@endif
@if( ! empty( $description = $cr['content'] ) )
  <p class="description text-center mb-3">{!!  $description !!}</p>
@endif

<form>
  <div class="input-group input-group-custom input-group-lg">
    <span class="input-group-addon">{{ __('Purchase price', 'hux') }}  {!! App\generate_currency_signs() !!}</span>
    <input type="text" class="form-control" id="purchase_price">
  </div>

  <div class="input-group input-group-custom input-group-lg">
    <span class="input-group-addon"><i>{{ __('LTV % you wish to borrow', 'hux') }}</i> <span class="line"></span></span>
    <select class="form-control form-control-lg" id="ltv">
      @foreach($cr['ltv'] as $ltv)
        <option value="{{ strtolower($ltv['option']) }}">{{ $ltv['option'] }}%</option>
      @endforeach
    </select>
  </div>

  <div class="input-group input-group-custom input-group-lg">
    <span class="input-group-addon"><i>{{ __('Interest rate', 'hux') }}</i> <span class="line"></span></span>
    <select class="form-control form-control-lg" id="interest_rate">
      @foreach($cr['interest_rate'] as $ltv)
        <option value="{{ strtolower($ltv['option']) }}">{{ $ltv['option'] }}%</option>
      @endforeach
    </select>
  </div>

  <div class="input-group input-group-custom input-group-lg">
    <span class="input-group-addon"><i>{{ __('Term length', 'hux') }}</i> <span class="line"></span></span>
    <select class="form-control form-control-lg" id="term_length">
      @foreach($cr['term_length'] as $ltv)
        <option value="{{ strtolower($ltv['option']) }}">{{ $ltv['option'] }} {{ __('years', 'hux') }}</option>
      @endforeach
    </select>
  </div>

  <p class="validation_error d-none y">{{ __('Please Fill in All Fields', 'hux') }}</p>

  <div class="d-flex justify-content-center mt-3">
    <button class="btn btn-primary btn-payments" type="submit">{{ __('calculate payments', 'hux') }}</button>
  </div>
  <div class="capital-result d-none mt-3">
    <p>
      <span class="title">{{ __('borrowing amount', 'hux') }}</span>
      {!! App\generate_currency_signs() !!}<span id="borrowing-amount"></span>
    </p>
    <p>
      <span class="title">{{ __('Monthly mortgage payments', 'hux') }}</span>
      {!! App\generate_currency_signs() !!}<span id="monthly-mortgage"></span>
    </p>
  </div>
</form>
