@if( have_rows('quotes') )
  @while( have_rows('quotes') ) @php the_row() @endphp

  @php
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'quotes' . '-' ),
      'title' => get_sub_field( 'title' ),
      'quotes_to_show' => get_sub_field( 'quotes_to_show' ),
      'orderby' => get_sub_field( 'orderby' ),
      'order' => get_sub_field( 'order' ),
      'image' => get_sub_field( 'image' ),
      'background' => get_sub_field( 'background' ),
      'slider_settings' => get_sub_field( 'quotes_slider_settings' ),
    ];

    $classes = [
      'layout-item',
      'quotes',
      $fields['background'],
    ];

    $fields['quotes'] = get_posts([
      'post_type' => 'hux_quote',
      'post_status' => 'publish',
      'orderby' => $fields['orderby'],
      'order' => $fields['order'],
      'posts_per_page' => absint( $fields['quotes_to_show'] )
    ]);

    if( \App\layout_has_bg( $fields['background'] ) ) {
      $classes[] = 'has-bg';
    }
  @endphp

  @if( ! empty( $fields['quotes'] ) )
    <section id="{{ $fields['layout_id'] }}" class="{{ implode( ' ', $classes ) }}">
      <div class="row flex-md-row-reverse ml-0 mr-0">
        <div class="col-md-6 pl-0 pr-0">
          @if( ! empty( $fields['image'] ) )
            <figure class="quotes-thumbnail img-cover mb-0">
              {!! \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail' ) !!}
            </figure>
          @endif
        </div>

        <div class="col-md-6 pl-0 pr-0 justify-content-centeralign-items-center">
          <div class="quotes-carousel-wrap {{ $fields['slider_settings']['dots'] === 'enabled' ? 'has-dots' : '' }} {{ $fields['slider_settings']['arrows'] === 'enabled' ? 'has-arrows' : '' }}">
            @if( ! empty( $fields['title'] ) )
              <h3 class="quotes-title">{{ $fields['title'] }}</h3>
            @endif

            <div class="quotes-carousel"
                 data-arrows="{{ $fields['slider_settings']['arrows'] }}"
                 data-dots="{{ $fields['slider_settings']['dots'] }}"
                 data-autoplay="{{ $fields['slider_settings']['autoplay'] }}"
                 data-interval="{{ $fields['slider_settings']['interval'] * 1000 }}">

              @foreach( $fields['quotes'] as $quote )
                @if( ! empty( $quote = get_field( 'quote', $quote->ID ) ) )
                  <div class="quotes-slide">
                    <div class="quotes-slide-inner">
                      <i class="quote-icon hux-icon-quotes-left"></i>
                      <q class="quote-text rlpm">
                        {!! $quote !!}
                      </q>
                    </div>
                  </div>
                @endif
              @endforeach
            </div>

            <div class="quotes-arrows"></div>
          </div>
        </div>
      </div>
    </section>
  @endif

  @endwhile
@endif
