@if( have_rows('form') )
  @while( have_rows('form') ) @php the_row() @endphp

  @php
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'form' . '-' ),
      'form_type' => get_sub_field( 'form_type' ),
      'form_internal' => get_sub_field( 'form_internal' ),
      'form_external' => get_sub_field( 'form_external' ),
      'padding' => get_sub_field( 'form_padding' ),
    ];

    $classes = [
      'layout-item',
      'form_block',
      'pt-' . $fields['padding']['top'],
      'pb-' . $fields['padding']['bottom']
    ];
  @endphp

  @if( ! empty( $fields[ 'form_' . $fields['form_type'] ] ) )
    <section id="{{ $fields['layout_id'] }}" class="{{ implode( ' ', $classes ) }}">
      <div class="container">
        @if( $fields['form_type'] === 'internal' )
          @php( gravity_form( $fields['form_internal']['id'], false, false, false, '', true, 1 ) )
        @else
          {!! $fields['form_external'] !!}
        @endif

      </div>
    </section>
  @endif

  @endwhile
@endif
