@php
  $fields = [
    'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( get_row_layout() . '-' ),
    'form_title' =>  get_sub_field('form_title'),
    'form' =>  get_sub_field('form'),
    'offices' =>  get_sub_field('offices'),
  ];
@endphp

<section id="{{ $fields['layout_id'] }}" class="layout-item {{  get_row_layout() }}">
  <div class="container">
    <div class="row">
      <div class="col-md-4 office-column">
        @foreach($fields['offices'] as $office)
          <div class="office-item">
            @if( ! empty( $title = $office['name'] ) )
              <h5 class="office-title">{{ $title }}</h5>
            @endif

            @if( ! empty( $phone = $office['phone'] ) )
              <a href="tel: {{ $phone }}" rel="nofollow" title="{{ __('Call Us', 'hux') }}"
                 class="phone">{{ $phone }}</a>
            @endif

            @if( ! empty( $email = $office['email'] ) )
              <a href="mail: {{ $email }}" rel="nofollow" title="{{ __('Email Us', 'hux') }}"
                 class="email">{{ $email }}</a>
            @endif
          </div>
        @endforeach
      </div>
      <div class="col-md-8">
        <div class="form-column">
          @if( ! empty( $form_title = $fields['form_title'] ) )
            <h3 class="form-title">{{ $form_title }}</h3>
          @endif
          @if( ! empty( $fields['form'] ) )
            @php( gravity_form( $fields['form']['id'], false, false, false, '', true, 1 ) )
          @endif
        </div>
      </div>
    </div>
  </div>
</section>
