@php
  $fields = [
    'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'calculator-' ),
    'yield_tab' => get_field('cr', 'option'),
    'capital_tab' => get_field('cp', 'option'),
  ];
@endphp

<section id="{{ $fields['layout_id'] }}" class="layout-item calculator">
  <div class="container">
    <div class="calculator-body">
      <div class="nav nav-pills" id="calculator-tab" role="tablist" aria-orientation="vertical">
        <a class="nav-link active" id="calculator-yield-tab" data-toggle="pill" href="#calculator-yield" role="tab"
           aria-controls="v-pills-home" aria-selected="true">
          <i class="hux-icon-stat" aria-hidden="true"></i>
          @if( ! empty( $text = $fields['yield_tab']  ['tab_text'] ) )
            {{ $text }}
          @endif
        </a>
        <a class="nav-link" id="calculator-mortgage-tab" data-toggle="pill" href="#calculator-mortgage" role="tab"
           aria-controls="calculator-mortgage-tab">
          <i class="hux-icon-stat" aria-hidden="true"></i>
          @if( ! empty( $text = $fields['capital_tab']  ['tab_text'] ) )
            {{ $text }}
          @endif
        </a>
      </div>
      <div class="tab-content" id="calculator-tabContent">
        <div class="tab-pane fade show active" id="calculator-yield" role="tabpanel"
             aria-labelledby="calculator-yield-tab">
          @include('partials.calculator-yield')
        </div>
        <div class="tab-pane fade" id="calculator-mortgage" role="tabpanel" aria-labelledby="calculator-mortgage-tab">
          @include('partials.calculator-capital')
        </div>
      </div>
    </div>
  </div>
</section>
