@extends('layouts.app')
@php
  $contentAnim = array(
    'animation' => 'fade-up',
    'delay'     => 0.1,
    'duration'  => 1,
    'easing'    => '',
    'anchor'    => ''
  );
@endphp

@section('content')
  @include('partials.content-page')

  <div class="container">
    @if (!have_posts())
      <div class="alert alert-warning">
        {{ __('Sorry, no results were found.', 'hux') }}
      </div>
    @endif

    <div class="posts-wrap">
      <h3 class="text-center text-uppercase mb-4">{{ __('Current Vacancies', 'hux') }}</h3>

      @while (have_posts()) @php(the_post())
      @include ('partials.content-'.(get_post_type() !== 'post' ? get_post_type() : get_post_format()))
      @endwhile
    </div>
    @include('partials.load-more')
  </div>
@endsection
