@extends('layouts.app')
@php
  $contentAnim = array(
    'animation' => 'fade-up',
    'delay'     => 0.1,
    'duration'  => 1,
    'easing'    => '',
    'anchor'    => ''
  );
@endphp

@section('content')
  @include('partials.content-page')

  <div class="container">
    @if (!have_posts())
      <div class="alert alert-danger">
        {{ __('Sorry, no properties were found.', 'hux') }}
      </div>
    @endif

    @include('partials.content-hux_property-filter')
    <div class="alert alert-danger d-none mt-7">
      {{ __('Sorry, no properties were found.', 'hux') }}
    </div>
    <div class="posts-wrap">
      @while (have_posts()) @php(the_post())
      @include ('partials.content-'.(get_post_type() !== 'post' ? get_post_type() : get_post_format()))
      @endwhile
    </div>
    @include('partials.load-more')
  </div>
@endsection
