import 'imagesloaded';
import 'jquery.actual/jquery.actual';
import Modernizr from 'modernizr';
import _ from 'lodash';

export const eHeight = (conf) => {
  const defaults = {
    base: 'body',
    container: '.eh-container',
    child: '.eh-child',
    minWidth: 0,
    maxWidth: null,
    tool: 'height',
    minHeight: 0,
    trigger: true,
  };

  const config = {
    ...defaults,
    ...conf,
  };

  const $containers = $(config.container, config.base);

  $containers.each((containerIndex, container) => {
    const minWidth = $(container).data('min') || config.minWidth;
    const maxWidth = $(container).data('max') || config.maxWidth;
    const tool = $(container).data('tool') || config.tool;
    const children = $(container).find(config.child);
    const minHeight = config.minHeight;

    let mq = `(min-width: ${minWidth}px)`;
    let maxHeight = 0;

    if (maxWidth) {
      mq = `${mq} and (max-width: ${maxWidth}px)`;
    }

    if (Modernizr.mq(mq)) {
      $(container).imagesLoaded(() => {
        children.each((childIndex, child) => {
          if (tool === 'height') {
            $(child).css({
              height: 'auto',
            });
          }

          if (tool === 'padding') {
            children.find('.eheight-padder').remove();
          }

          if ($(child).actual('outerHeight') > maxHeight) {
            maxHeight = $(child).actual('outerHeight');
          }
        });

        if (maxHeight < minHeight) {
          maxHeight = minHeight;
        }

        if (tool === 'height') {
          children.css({
            height: maxHeight,
          });
        }

        if (tool === 'padding') {
          children.each((index, child) => {
            if (!$(child).is(':visible')) {
              $(child).closest('.tab-pane').addClass('active eh-active');
            }

            if (maxHeight > $(child).actual('outerHeight')) {
              const padder = (maxHeight - $(child).actual('outerHeight')) / 2;
              $(`<div class="eheight-padder" style="height: ${padder}px;"></div>`).appendTo($(child));
              $(`<div class="eheight-padder" style="height: ${padder}px;"></div>`).prependTo($(child));
            }

            $(child).closest('.eh-active').removeClass('active eh-active');
          });
        }

        $('body').trigger('eheight-finished');
      });
    } else {
      if (tool === 'height') {
        children.css({
          height: 'auto',
        });
      }

      if (tool === 'padding') {
        children.find('.eheight-padder').remove();
      }
    }

    if(config.trigger) {
      $('body').trigger('eheight-finished');
    }
  });
};

const eHeightDebounced = _.debounce(eHeight, 150);

export default eHeightDebounced;
