import * as Cookies from "js-cookie";

const switchLanguage = () => {
  const default_lang = window.huxGlobals.currency;
  const switcher = $('.switch-currency');
  //Switcher
  switcher.html(default_lang);

  //Content
  $('.lng-switcher').removeClass('d-inline-block').addClass('d-none');
  $('.lng-switcher.lng-' + default_lang).removeClass('d-none').addClass('d-inline-block');

  switcher.html($('*[data-currency="' + default_lang + '"]').innerHTML);

  $('.currency-items .dropdown-item').on('click', (e) => {
    e.preventDefault();
    $('.switch-currency').html(e.target.innerHTML);
    const selected = $(e.target).data('currency').toLowerCase();

    $('.lng-switcher').removeClass('d-inline-block').addClass('d-none');
    $('.lng-switcher.lng-' + selected).removeClass('d-none').addClass('d-inline-block');
    window.huxGlobals.currency = selected;
    Cookies.set('hux_currency', selected, { expires: 7 });
    $('body').trigger('currencyChanged')
  });
};

export default switchLanguage;
