import 'ion-rangeslider'

const range = () => {
  const default_crn = window.huxGlobals.currency;

  const rslider = $('.js-range-slider');
  rslider.data('min', rslider.data('min-' + default_crn));
  rslider.data('max', rslider.data('max-' + default_crn));

  const max = rslider.data('max');
  const min = rslider.data('min');

  rslider.ionRangeSlider({
    type: "double",
    min: min,
    max: max,
    step: 1000,
    from: min,
    to: max,
    prefix: rslider.data('sign-' + default_crn),
    force_edges: true,
    onFinish: () => {
      rslider.trigger('changeMaxPrice')
    },
  })
  ;

  const instance = rslider.data("ionRangeSlider");

  $('body').on('currencyChanged', () => {
    rslider.data('max', rslider.data(window.huxGlobals.currency));

    const new_max = rslider.data('max-' + window.huxGlobals.currency);
    const new_min = rslider.data('min-' + window.huxGlobals.currency);
    const new_prefix = rslider.data('sign-' + window.huxGlobals.currency);

    instance.update({
      max: new_max,
      to: new_max,
      min: new_min,
      from: new_min,
      prefix: new_prefix,
    });
  });


};

export default range;
