import 'slick-carousel';

const postTypeCarousel = () => {
  const $carousels = $('.layout-item.post_type_carousel');

  $carousels.each((index, container) => {
    const $carousel = $('.post-type-carousel', container);

    $carousel.slick({
      arrows: $carousel.data('arrows') === 'enabled' && $carousel.data('dots') !== 'enabled',
      dots: $carousel.data('dots') === 'enabled' || $carousel.data('arrows') === 'enabled',
      autoplay: $carousel.data('autoplay') === 'enabled',
      autoplaySpeed: $carousel.data('interval'),
      prevArrow: '<button type="button" class="slick-prev"><i class="hux-icon-chevron-left" aria-hidden="true"></i></button>',
      nextArrow: '<button type="button" class="slick-next"><i class="hux-icon-chevron-right" aria-hidden="true"></i></button>',
      appendArrows: $('.ptc-arrows', container),
      swipe: $carousel.data('arrows') === 'enabled' || $carousel.data('dots') === 'enabled',
      draggable: $carousel.data('arrows') === 'enabled' || $carousel.data('dots') === 'enabled',
      slidesToScroll: 1,
      slidesToShow: 3,
      responsive: [
        {
          breakpoint: 992,
          settings: {
            slidesToShow: 2,
          },
        },
        {
          breakpoint: 576,
          settings: {
            slidesToShow: 1,
          },
        },
      ],
    });
  });
};

export default postTypeCarousel;
