import 'imagesloaded';
import manageImgCover from '../util/imgCover';
import currencySwitch from '../src/switchCurrency'

class manageProperties {

  constructor() {
    this.$grid = $('.posts-wrap');
    this.$moreButton = $('.btn-load-more');
    this.$regionFilterSelect = $('.content-hux_property-filter .region-select');
    this.$statusFilterSelect = $('.content-hux_property-filter .status-select');
    this.$priceFilterSelect = $('.content-hux_property-filter .js-range-slider');
    this.$error = $('.alert.alert-danger');
    this.globals = window.huxGlobals;
    this.data = {
      action: 'hux_load_properties',
      offset: 0,
      region: null,
      status: null,
      currency: this.globals.currency,
      min_price: this.$priceFilterSelect.prop('value').split(';')[0],
      max_price: this.$priceFilterSelect.prop('value').split(';')[1],
      nonce: this.globals.nonce,
      post_type: this.globals.post_type,
      posts_per_page: this.globals.posts_per_page,
    };

    this.manageCurrencies();
    this.manageLoadMore();
    this.manageFilters();
  }

  getProperties() {
    $('body').addClass('posts-loading');

    return $.ajax({
      method: 'POST',
      url: this.globals.ajax_url,
      dataType: 'json',
      data: this.data,
      success: () => {
        $('body').removeClass('posts-loading');
      },
    });
  }

  handleResponse(response) {

    if (response.success) {
      this.$error.addClass('d-none');
      const $elems = $(response.data.html);
      this.$moreButton.removeClass('loading').attr('disabled', false);

      if (this.data.offset > 0) {
        this.$grid.append($elems);
        currencySwitch();
        $elems.imagesLoaded(() => {
          manageImgCover();
        });
      } else {
        this.$grid.empty();
        this.$grid.append($elems);
        currencySwitch();
        $elems.imagesLoaded(() => {
          manageImgCover();
        });
      }

      if (parseInt(response.data.count) === $('.hentry').length) {
        this.$moreButton.parent().removeClass('d-flex').addClass('d-none');
      } else {
        this.$moreButton.parent().removeClass('d-none').addClass('d-flex');
      }

    } else {
      this.$grid.empty();
      this.$error.removeClass('d-none');
      this.$moreButton.parent().removeClass('d-flex').addClass('d-none');
    }
  }

  // Handle load more items
  manageLoadMore() {
    this.$moreButton.on('click', (e) => {
      e.preventDefault();

      this.$moreButton.toggleClass('loading').attr('disabled', true);

      this.data.offset = $('.hentry', this.$grid).length;

      const posts = this.getProperties();

      posts.success((response) => {
        this.handleResponse(response);
      });
    });
  }

  manageFilters() {
    this.$regionFilterSelect.on('change', (e) => {
      e.preventDefault();
      const region = $(e.target).find(':selected').data('region');

      if (region !== undefined) {
        this.data.region = region;
      } else {
        this.data.region = null;
      }
      // Reset the offset because we change filters
      this.data.offset = 0;

      const posts = this.getProperties();
      posts.success((response) => {
        this.handleResponse(response);
      });
    });

    this.$statusFilterSelect.on('change', (e) => {
      e.preventDefault();
      const status = $(e.target).find(':selected').data('status');

      if (status !== undefined) {
        this.data.status = status;
      } else {
        this.data.status = null;
      }
      // Reset the offset because we change filters
      this.data.offset = 0;

      const posts = this.getProperties();
      posts.success((response) => {
        this.handleResponse(response);
      });
    });

    // this.$priceFilterSelect.on('changeMaxPrice', () => {
    //   this.data.min_price = this.$priceFilterSelect.prop("value").split(';')[0];
    //   this.data.max_price = this.$priceFilterSelect.prop("value").split(';')[1];
    //
    //   // Reset the offset because we change filters
    //   this.data.offset = 0;
    //
    //   const posts = this.getProperties();
    //   posts.success((response) => {
    //     this.handleResponse(response);
    //   });
    // });
  }

  manageCurrencies() {
    $('body').on('currencyChanged', () => {
      this.data.currency = this.globals.currency;
      this.data.min_price = this.$priceFilterSelect.prop('value').split(';')[0];
      this.data.max_price = this.$priceFilterSelect.prop('value').split(';')[1];

      this.data.offset = 0;

      const posts = this.getProperties();
      posts.success((response) => {
        this.handleResponse(response);
      });
    });
  }
}

const loadProperties = () => {
  new manageProperties();
};

export default loadProperties;
