class Calculator {
  constructor() {
    this.$returnButton = $('.btn-return');
    this.$paymentsButton = $('.btn-payments');
    this.grossAnnual = $('#gross-annual');
    this.netAnnual = $('#net-annual');
    this.cNetYield = $('#c-net-yield');
    this.lNetYield = $('#l-net-yield');
    this.borrowingAmount = $('#borrowing-amount');
    this.monthlyMortgage = $('#monthly-mortgage');
    this.yieldResult = $('.yield-result');
    this.capitalResult = $('.capital-result');
    this.yError = $('.y.validation_error');

    this.calculateYield();
    this.calculatePayment();
    this.manageLabel();
  }

  calculateYield() {
    this.$returnButton.on('click', (e) => {
      e.preventDefault();

      const property_value = $('#property_value').val();
      const monthlyIncome = $('#monthly_income').val();

      if (property_value === "" || monthlyIncome === "") {
        this.yieldResult.addClass('d-none');
        this.yError.removeClass('d-none');
        return;
      }

      this.yError.addClass('d-none');

      const grossAnnual = monthlyIncome * 12;
      this.grossAnnual.html(this.addComma(grossAnnual));

      const netAnnual = grossAnnual - ( grossAnnual * 0.1);
      this.netAnnual.html(this.addComma(netAnnual));

      const cNetYield = netAnnual / property_value * 100;
      this.cNetYield.html(parseFloat(cNetYield.toFixed(2)));

      const lNetYield = netAnnual / (property_value * 0.3) * 100;
      this.lNetYield.html(parseFloat(lNetYield.toFixed(2)));

      this.yieldResult.removeClass('d-none');
    });
  }

  calculatePayment() {
    this.$paymentsButton.on('click', (e) => {
      e.preventDefault();

      const purchase_price = $('#purchase_price').val();
      const ltv = $('#ltv').val();
      const interest_rate = $('#interest_rate').val();
      const term_length = $('#term_length').val();

      if (purchase_price === "" || ltv === "" || interest_rate === "" || term_length === "") {
        this.capitalResult.addClass('d-none');
        this.yError.removeClass('d-none');
        return;
      }

      this.yError.addClass('d-none');

      const borrowingAmount = purchase_price - (purchase_price * (ltv * 0.01));
      this.borrowingAmount.html(this.addComma(borrowingAmount));

      const monthlyMortgage = borrowingAmount * (interest_rate * 0.01) / 12;
      this.monthlyMortgage.html(this.addComma(monthlyMortgage.toFixed(2)));

      this.capitalResult.removeClass('d-none');
    });
  }

  manageLabel() {
    $('.calculator .form-control').keyup((e) => {
      if (e.target.value !== "") {
        $(e.target).closest('.input-field').addClass('changed');
      } else {
        $(e.target).closest('.input-field').removeClass('changed');
      }
    });
  }

  addComma(x) {
    return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
  }


}

const createCalculator = () => {
  new Calculator;
};

export default createCalculator;
