// Import everything from autoload
import "./autoload/**/*"

// import local dependencies
import Router from './util/Router';
import common from './routes/common';
import blog from './routes/blog';
import postTypeArchiveHuxCase from './routes/post-type-archive-hux_case';
import postTypeArchiveHuxVacancy from './routes/post-type-archive-hux_vacancy';
import postTypeArchiveHuxProperty from './routes/post-type-archive-hux_property';

/** Populate Router instance with DOM routes */
const routes = new Router({
  common,
  blog,
  postTypeArchiveHuxCase,
  postTypeArchiveHuxVacancy,
  postTypeArchiveHuxProperty,
});

// Load Events
jQuery(document).ready(() => routes.loadEvents());
