<?php namespace App\HUX\PostTypes\Quote;

/**
 * Register hux_quote post type
 */
add_action( 'init', function () {

    $labels = array(
        'name'                  => _x( 'Quotes', 'Post Type General Name', 'hux' ),
        'singular_name'         => _x( 'Quote', 'Post Type Singular Name', 'hux' ),
        'menu_name'             => __( 'Quotes', 'hux' ),
        'name_admin_bar'        => __( 'Quotes', 'hux' ),
        'archives'              => __( 'Quote Archives', 'hux' ),
        'attributes'            => __( 'Quote Attributes', 'hux' ),
        'parent_item_colon'     => __( 'Parent Quote:', 'hux' ),
        'all_items'             => __( 'All Quotes', 'hux' ),
        'add_new_item'          => __( 'Add New Quote', 'hux' ),
        'add_new'               => __( 'Add New', 'hux' ),
        'new_item'              => __( 'New Quote', 'hux' ),
        'edit_item'             => __( 'Edit Quote', 'hux' ),
        'update_item'           => __( 'Update Quote', 'hux' ),
        'view_item'             => __( 'View Quote', 'hux' ),
        'view_items'            => __( 'View Quotes', 'hux' ),
        'search_items'          => __( 'Search Quote', 'hux' ),
        'not_found'             => __( 'Not found', 'hux' ),
        'not_found_in_trash'    => __( 'Not found in Trash', 'hux' ),
        'featured_image'        => __( 'Featured Image', 'hux' ),
        'set_featured_image'    => __( 'Set featured image', 'hux' ),
        'remove_featured_image' => __( 'Remove featured image', 'hux' ),
        'use_featured_image'    => __( 'Use as featured image', 'hux' ),
        'insert_into_item'      => __( 'Insert into quote', 'hux' ),
        'uploaded_to_this_item' => __( 'Uploaded to this quote', 'hux' ),
        'items_list'            => __( 'Quotes list', 'hux' ),
        'items_list_navigation' => __( 'Quotes list navigation', 'hux' ),
        'filter_items_list'     => __( 'Filter quotes list', 'hux' ),
    );


    $args = array(
        'label'               => __( 'Quote', 'hux' ),
        'description'         => __( 'Quote post type for HUX theme.', 'hux' ),
        'labels'              => $labels,
        'supports'            => array( 'title', 'author', 'revisions' ),
        'taxonomies'          => array(),
        'hierarchical'        => false,
        'public'              => false,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'menu_position'       => 20,
        'menu_icon'           => 'dashicons-testimonial',
        'show_in_admin_bar'   => false,
        'show_in_nav_menus'   => false,
        'can_export'          => true,
        'has_archive'         => false,
        'exclude_from_search' => true,
        'publicly_queryable'  => false,
        'rewrite'             => false,
        'capability_type'     => 'post',
        'show_in_rest'        => false,
    );

    register_post_type( 'hux_quote', $args );

}, 0 );
