<?php namespace App\HUX\Ajax\LoadPosts;

/**
 * Load more
 */
add_action('wp_ajax_hux_load_posts', __NAMESPACE__ . '\\hux_load_posts');
add_action('wp_ajax_nopriv_hux_load_posts', __NAMESPACE__ . '\\hux_load_posts');
function hux_load_posts()
{
    global $wp_query;

    if (!wp_verify_nonce($_REQUEST['nonce'], 'hux-nonce') ||
        !isset($_REQUEST['post_type']) ||
        !isset($_REQUEST['posts_per_page']) ||
        !isset($_REQUEST['offset'])
    ) {
        wp_send_json_error();
        exit;
    }

    $posts_per_page = absint($_REQUEST['posts_per_page']) / 2;
    $post_type = $_REQUEST['post_type'];
    $offset = absint($_REQUEST['offset']);

    $args = [
        'post_type' => $post_type,
        'offset' => $offset,
        'posts_per_page' => $posts_per_page,
    ];

    // Prepare the tax query
    if (!empty($_REQUEST['category'])) {
        $args['tax_query'][] = [
            'taxonomy' => 'category',
            'field' => 'slug',
            'terms' => [$_REQUEST['category']],
        ];
    }

    $wp_query = new \WP_Query($args);

    ob_start();

    $contentAnim = array(
        'animation' => 'fade-up',
        'delay'     => 0.1,
        'duration'  => 1,
        'easing'    => '',
        'anchor'    => ''
    );
    $i = 0;
    if (have_posts()) {

        while (have_posts()) {
            the_post();

            if ($i % 4 == 0) {
                echo \App\template('partials.content-featured');
            } else {
                echo \App\template('partials.content');
            }

            if ($i % 4 ==  0) {
                echo '
                      <div class="container">
                       <div class="posts-default-wrap eh-container" '. \App\get_the_aos($contentAnim) . '>
                       <div class="posts-default row">';
            }

            $i++;
        }

        echo '</div></div></div>';
    } else {
        wp_send_json_error();
        exit;
    }

    $html = ob_get_clean();

    $total_count = 0;
    $count_posts = wp_count_posts($post_type);

    if (isset($count_posts->publish)) {
        $total_count = $count_posts->publish;
    }

    wp_send_json_success([
        'html' => preg_replace('/\v(?:[\v\h]+)/', '', $html),
        'count' => isset($wp_query->found_posts) ? $wp_query->found_posts : $total_count,
        'offset' => $offset,
        'args' => $args
    ]);

    exit;
}
