<?php namespace App\HUX\Ajax\LoadCases;

/**
 * Load more
 */
add_action('wp_ajax_hux_load_cases', __NAMESPACE__ . '\\hux_load_cases');
add_action('wp_ajax_nopriv_hux_load_cases', __NAMESPACE__ . '\\hux_load_cases');
function hux_load_cases()
{
    global $wp_query;

    if (!wp_verify_nonce($_REQUEST['nonce'], 'hux-nonce') ||
        !isset($_REQUEST['post_type']) ||
        !isset($_REQUEST['posts_per_page']) ||
        !isset($_REQUEST['offset'])
    ) {
        wp_send_json_error();
        exit;
    }

    $posts_per_page = absint($_REQUEST['posts_per_page']);
    $post_type = $_REQUEST['post_type'];
    $offset = absint($_REQUEST['offset']);

    $args = [
        'post_type' => $post_type,
        'offset' => $offset,
        'posts_per_page' => $posts_per_page,
    ];

    $wp_query = new \WP_Query($args);

    ob_start();

    if (have_posts()) {
        while (have_posts()) {
            the_post();
            echo \App\template('partials.content-hux_case');
        }
    } else {
        wp_send_json_error();
        exit;
    }

    $html = ob_get_clean();

    $total_count = 0;
    $count_posts = wp_count_posts($post_type);

    if (isset($count_posts->publish)) {
        $total_count = $count_posts->publish;
    }

    wp_send_json_success([
        'html' => preg_replace('/\v(?:[\v\h]+)/', '', $html),
        'count' => isset($wp_query->found_posts) ? $wp_query->found_posts : $total_count,
        'offset' => $offset,
        'args' => $args
    ]);

    exit;
}
