import Modernizr from 'modernizr';

const scrollTo = () => {
  $('a').not('[data-toggle=collapse]').on('click', (e) => {

    if (/^#/.test($(e.currentTarget).attr('href')) || $(e.currentTarget).hasClass('scroll-to')) {
      let offset;
      const target = $(e.currentTarget).attr('href');

      if ($(target).length) {
        e.preventDefault();

        if (target === 'body') {
          offset = 0;
        } else {
          offset = $(target).offset().top;

          if (Modernizr.mq('(min-width: 992px)')) {
            offset = offset - $('.banner .bottom').height();
          } else {
            offset = offset - $('.banner .top').height();
          }
        }

        $('html, body').stop().animate({
          scrollTop: offset,
        }, 1250, 'easeInOutExpo');
      }
    }
  });
};

export default scrollTo;
