// Utils
import initScrollTo from '../util/scrollTo';
import { eHeight } from '../util/eHeight';
import manageEheight from '../util/eHeight';
import { imgCover } from '../util/imgCover';
import manageImgCover from '../util/imgCover';

// Components
import initAOS from '../src/aos';
import initMobileNavigation from '../src/mobileNavigation';
import initPostTypeCarousel from '../src/postTypeCarousel';
import initQuotes from '../src/quotes';
import initStickyNavigation from '../src/stickyNavigation';

export default {
  init() {
    eHeight();
    imgCover();
    initAOS();
    initMobileNavigation();
    initPostTypeCarousel();
    initQuotes();
    initScrollTo();
    initStickyNavigation();

    $('body').on('eheight-finished', () => {
      imgCover();
    });

    $(window).on('resize', () => {
      manageEheight();
      manageImgCover();
    });
  },
};
