<?php

// exit if accessed directly
if( ! defined( 'ABSPATH' ) ) exit;


// check if class already exists
if( !class_exists('acf_field_currency') ) :


class acf_field_currency extends acf_field {


	/*
	*  __construct
	*
	*  This function will setup the field type data
	*
	*  @type	function
	*  @date	5/03/2014
	*  @since	5.0.0
	*
	*  @param	n/a
	*  @return	n/a
	*/

	function __construct( $settings ) {

        $this->name = 'currency';
        $this->label = __( 'Currency', 'acf-currency' );
        $this->category = 'content';
        $this->defaults = array();
        $this->l10n = array();
        $this->settings = $settings;

        // do not delete!
        parent::__construct();

	}


	/*
	*  render_field()
	*
	*  Create the HTML interface for your field
	*
	*  @param	$field (array) the $field being rendered
	*
	*  @type	action
	*  @since	3.6
	*  @date	23/01/13
	*
	*  @param	$field (array) the $field being edited
	*  @return	n/a
	*/

	function render_field( $field ) {

        if ( ! empty( $this->settings['currencies'] ) ):
            foreach ( $this->settings['currencies'] as $currency ): ?>
                <div class="acf-input">
                    <div class="acf-input-prepend"><?= $currency['code']; ?></div>
                    <div class="acf-input-wrap">
                        <input type="number" step="any"
                               name="<?= esc_attr( $field['name'] ); ?>[<?= strtolower( $currency['code'] ); ?>]"
                               value="<?= esc_attr( $field['value'][ strtolower( $currency['code'] ) ] ); ?>"/>
                    </div>
                </div>
            <?php endforeach;
        else:
            ?>
            <a href="edit.php?post_type=acf-field-group&page=acf-currency-settings" class="acf-button button button-primary" title="<?= __( 'Add Currency', 'acf-currency' ); ?>">
                <?= __( 'Add Currency', 'acf-currency' ); ?>
            </a>
            <?php
        endif;
	}


	/*
	*  input_admin_enqueue_scripts()
	*
	*  This action is called in the admin_enqueue_scripts action on the edit screen where your field is created.
	*  Use this action to add CSS + JavaScript to assist your render_field() action.
	*
	*  @type	action (admin_enqueue_scripts)
	*  @since	3.6
	*  @date	23/01/13
	*
	*  @param	n/a
	*  @return	n/a
	*/

	function input_admin_enqueue_scripts() {

		// vars
		$url = $this->settings['url'];
		$version = $this->settings['version'];

		// register & include CSS
		wp_register_style( 'acf-input-currency', "{$url}assets/css/input.css", array('acf-input'), $version );
		wp_enqueue_style('acf-input-currency');

	}


	/*
	*  format_value()
	*
	*  This filter is appied to the $value after it is loaded from the db and before it is returned to the template
	*
	*  @type	filter
	*  @since	3.6
	*  @date	23/01/13
	*
	*  @param	$value (mixed) the value which was loaded from the database
	*  @param	$post_id (mixed) the $post_id from which the value was loaded
	*  @param	$field (array) the field array holding all the field options
	*
	*  @return	$value (mixed) the modified value
	*/

    function format_value( $value, $post_id, $field ) {

        if ( empty( $value ) ) {

            return array();
        }

        $currencies    = $this->settings['currencies'];
        $number_format = $this->settings['number_format'];

        $currencies_by_code = array();

        if ( ! empty( $currencies ) ) {

            foreach ( $currencies as $currency ) {
                $currencies_by_code[ strtolower( $currency['code'] ) ] = $currency;
            }
        }

        $results = array();

        if ( ! empty( $value ) ) {

            foreach ( $value as $code => $number ) {

                if ( isset( $currencies_by_code[ $code ] ) && ( ! empty( $number ) || ( (string) $number === '0' ) ) ) {

                    $results[] = array(
                        'code'           => $currencies_by_code[ $code ]['code'],
                        'sign'           => $currencies_by_code[ $code ]['sign'],
                        'value'          => $number,
                        'formated_value' => number_format( $number, $number_format['decimals'], $number_format['dec_point'], $number_format['thousands_sep'] ),
                    );
                }
            }
        }

        return $results;
    }


	/*
	*  validate_value()
	*
	*  This filter is used to perform validation on the value prior to saving.
	*  All values are validated regardless of the field's required setting. This allows you to validate and return
	*  messages to the user if the value is not correct
	*
	*  @type	filter
	*  @date	11/02/2014
	*  @since	5.0.0
	*
	*  @param	$valid (boolean) validation status based on the value and the field's required setting
	*  @param	$value (mixed) the $_POST value
	*  @param	$field (array) the field array holding all the field options
	*  @param	$input (string) the corresponding input name for $_POST value
	*  @return	$valid
	*/

	function validate_value( $valid, $value, $field, $input ){

        if ( $field['required'] ) {
            foreach ( $value as $number ) {
                if ( empty( $number ) && ( (string) $number !== '0' ) ) {
                    $valid = false;
                }
            }
        }

        return $valid;
	}


}


// initialize
new acf_field_currency( $this->settings );


// class_exists check
endif;

?>
